TotemusFuBar = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "FuBarPlugin-2.0");

TotemusFuBar.name = "Totemus";
TotemusFuBar.version = Totemus.versions;
TotemusFuBar.date = Totemus.date;
TotemusFuBar.hasIcon = "Interface\\Icons\\Spell_Nature_BloodLust";
TotemusFuBar.hasNoColor = true;
TotemusFuBar.defaultMinimapPosition = 285;
TotemusFuBar.clickableTooltip = false;
TotemusFuBar.hideWithoutStandby = true;
TotemusFuBar.independentProfile = true;
TotemusFuBar.cannotDetachTooltip = true;

-- localisation

function TotemusFuBar:OnInitialize()
	self.db = Totemus:AcquireDBNamespace("fubar");
	fubarOptions = {
		type = 'group',
        args = {}
	}
	self.OnMenuRequest = fubarOptions;
end

local L = AceLibrary('AceLocale-2.2'):new('Totemus');
local Tablet = AceLibrary("Tablet-2.0");

function TotemusFuBar:OnTooltipUpdate()
    GameTooltip:Hide();
	local cat = Tablet:AddCategory("columns", 2)
    local itemCount, itemName = Totemus:InventoryGetItemData('ANKH');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Totemus:InventoryGetItemData('SCALE');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Totemus:InventoryGetItemData('OIL');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Totemus:InventoryGetItemData('DRINK');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Totemus:InventoryGetItemData('FOOD');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Totemus:InventoryGetItemData('POTION_MP');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
    local itemCount, itemName = Totemus:InventoryGetItemData('POTION_HP');
    if itemName ~= nil and itemCount ~= nil then
        cat:AddLine('text', '|cffffffff'..itemName..': |r', 'text2', itemCount);
    end
	Tablet:SetHint(L['CLICK_TOGGLE_CONFIG']);
end

function TotemusFuBar:OnClick(button)
    GameTooltip:Hide();
    TotemusConfig_Toggle();
end
